//
//  TTTSensorsViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/3/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTSensorsViewController.h"

@interface TTTSensorsViewController (){
    @private UIDeviceOrientation deviceOrientation;
    @private CMMotionManager *motionManager;
}

@end

@implementation TTTSensorsViewController

    @synthesize exitButton;
    @synthesize listOfSensorsView;
    @synthesize orientationTextView;
    @synthesize accelerationTextView;
    @synthesize gyroscopeTextView;
    @synthesize magnetometerTextView;

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        [listOfSensorsView setText:@""];
        orientationTextView.enabled = NO;
        accelerationTextView.enabled = NO;
        gyroscopeTextView.enabled = NO;
        magnetometerTextView.enabled = NO;
        
        self->deviceOrientation = UIDeviceOrientationUnknown;
        
        // start listening for orientation changes
        [[NSNotificationCenter defaultCenter]
         addObserver:self
         selector:@selector(orientationChanged:) name:@"UIDeviceOrientationDidChangeNotification"
         object:nil];
        
        [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];
        
        // Set up the motion manager
        
        self->motionManager = [[CMMotionManager alloc] init];
        self->motionManager.accelerometerUpdateInterval = 1;
        self->motionManager.gyroUpdateInterval = 1;
        self->motionManager. magnetometerUpdateInterval = 1;

    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

    - (IBAction) listCapabilities:(id)sender{
        
        // Testing for the network
        
        NSMutableString *textVal = [[NSMutableString alloc] init];
        NSString *networkReachability=nil;
        
        Reachability *reachFacade = [Reachability reachabilityForInternetConnection];
        NetworkStatus status = [reachFacade currentReachabilityStatus];
        if (status == NotReachable) networkReachability = @"No network\n";
        else if (status == ReachableViaWiFi) networkReachability = @"Wifi available\n";
        else if (status == ReachableViaWWAN) networkReachability = @"WAN available\n";
        [textVal appendString:networkReachability];
        
        // Testing for the camera
        
        BOOL cameraAvailable =
            [UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera];
        if (cameraAvailable == YES)[textVal appendString:@"Camera is available\n"];
        
        NSArray *cameraTypes =
        [UIImagePickerController availableMediaTypesForSourceType:UIImagePickerControllerSourceTypeCamera];
        int count = [cameraTypes count];
        for (int i = 0; i < count; i++) {
            NSString *cameraCapability = [cameraTypes objectAtIndex:i];
            if (CFStringCompare ((CFStringRef) cameraCapability, kUTTypeMovie, 0))
                [textVal appendString:@"Video capability is available\n"];
            if (CFStringCompare ((CFStringRef) cameraCapability, kUTTypeImage, 0))
                [textVal appendString:@"Still capability is available\n"];
        }
        
        
        // Testing for availability of audio
        AVAudioSession *audioSession = [AVAudioSession sharedInstance];
        if (audioSession.inputAvailable == YES) [textVal appendString:@"Audio input device is available\n"];
        
        [listOfSensorsView setText:textVal];
         
    }

    - (IBAction) getOrientation:(id)sender{
        NSString *orientationString=nil;
        switch (deviceOrientation){
            case UIDeviceOrientationUnknown:
                orientationString = @"Unknown";
                break;
            case UIDeviceOrientationPortrait:
                orientationString = @"Portrait";
                break;
            case UIDeviceOrientationPortraitUpsideDown:
                orientationString = @"Portrait Upside Down";
                break;
            case UIDeviceOrientationLandscapeLeft:
                orientationString = @"Landscape Left";
                break;
            case UIDeviceOrientationLandscapeRight:
                orientationString = @"Landscape Right";
                break;
            case UIDeviceOrientationFaceUp:
                orientationString = @"Face Up";
                break;
            case UIDeviceOrientationFaceDown:
                orientationString = @"Face Down";
                break;
            default:
                orientationString = @"Unknown";
        }
        [orientationTextView setText:orientationString];
        
    }

    - (void) orientationChanged: (NSNotification *) orientationNotification {
        deviceOrientation = [[UIDevice currentDevice] orientation];
    }

    - (void) handleAccelerationUpdates: (CMAcceleration) accelerationData {
        NSLog(@"Acceleration.x >%f<\n", accelerationData.x);
        NSLog(@"Acceleration.y >%f<\n", accelerationData.y);
        NSLog(@"Acceleration.z >%f<\n", accelerationData.z);
        if (((accelerationData.x > 1.0)||(accelerationData.x < -1.0))||
            ((accelerationData.y > 1.0)||(accelerationData.y < -1.0))||
            ((accelerationData.z > 1.0)||(accelerationData.z < -1.0))){
            [accelerationTextView setText:@"I'M GOING FAST!"];
        }else{
            [accelerationTextView setText:@"TOO SLOW"];
        }
    }

    - (void) handleGyroUpdates: (CMRotationRate) gyroRotationRate {
        NSLog(@"Rotation x >%f<\n", gyroRotationRate.x);
        NSLog(@"Rotation y >%f<\n", gyroRotationRate.y);
        NSLog(@"Rotation z >%f<\n", gyroRotationRate.z);
        if (((gyroRotationRate.x > 0.5)||(gyroRotationRate.x < -0.5))||
            ((gyroRotationRate.y > 0.5)||(gyroRotationRate.y < -0.5))||
            ((gyroRotationRate.z > 0.5)||(gyroRotationRate.z < -0.5))){
            [gyroscopeTextView setText:@"WHEEE!"];
        }else{
            [gyroscopeTextView setText:@"SPIN ME FASTER!"];
        }
    }

    - (void) handleMagnetometerUpdates: (CMMagneticField) magneticField {
        NSLog(@"Magnetic field x >%f<\n", magneticField.x);
        NSLog(@"Magnetic field y >%f<\n", magneticField.y);
        NSLog(@"Magnetic field z >%f<\n", magneticField.z);
        static float savedX=0.0, savedY=0.0, savedZ=00;
        float change = pow((magneticField.x - savedX), 2.0) + pow((magneticField.y - savedY), 2.0) + pow((magneticField.z - savedZ), 2.0);
        NSLog(@"Magnetic field change >%f<\n", change);
        if (change > 3000.0){
            savedX = magneticField.x;
            savedY = magneticField.y;
            savedZ = magneticField.z;
            [magnetometerTextView setText:@"I SENSE SOMETHING!"];
        }else{
            [magnetometerTextView setText:@"ALL CLEAR!"];
        }
    }


    - (IBAction) startMonitoringSensors:(id)sender{
        [self->motionManager
             startAccelerometerUpdatesToQueue:
                 [NSOperationQueue currentQueue]
                    withHandler:^(CMAccelerometerData *accelerometerData, NSError *error) {
                        [self handleAccelerationUpdates:accelerometerData.acceleration];
                  }
        ];
        
        [self->motionManager
             startGyroUpdatesToQueue:
                 [NSOperationQueue currentQueue]
                    withHandler:^(CMGyroData *gyroscopeData, NSError *error) {
                        [self handleGyroUpdates:gyroscopeData.rotationRate];
                   }
        ];
        [self->motionManager
             startMagnetometerUpdatesToQueue:
                 [NSOperationQueue currentQueue]
                    withHandler:^(CMMagnetometerData *magnetometerData, NSError *error) {
                        [self handleMagnetometerUpdates:magnetometerData. magneticField];
                 }
        ];
    }

    - (IBAction) stopMonitoringSensors:(id)sender{
        [self->motionManager stopAccelerometerUpdates];
        [self->motionManager stopGyroUpdates];
        [self->motionManager stopMagnetometerUpdates];
    }

    - (IBAction) exit:(id)sender{
        [self dismissViewControllerAnimated:YES completion:nil];
    }

@end
